% This procedure plots the impulse response functions for demand shocks
clear all
clc

path(pathdef)
addpath ./functions/

var_names   = {'a' 'u' 'p' 'prod_n' 'prod_o' 'prod_f' 'theta_n' 'theta_o' 'theta_f' ...
               'F_n' 'F_o' 'F_f' 'I_n' 'I_o' 'I_f' 'Y' 'L' 'K' 'C' 'r' 'o'};
shock_names = {'a' 'u'};


cd ./dynare_codes/

%% Get Fracking IRFs
% Need to run 'create Table_11' to obtain fracking_long_run_solution
load ../mat_files/fracking_long_run.mat

[IRF_a_f, IRF_u_f] = IRF_series_fracking(struct_param, shock_param, endo_ss);

%% Get No Fracking IRFs

load ../../../'Estimation Results'/Benchmark_Model.mat

[IRF_a, IRF_u] = IRF_series(parameters);

cd ../
%% Plot TFP Shock
time    = 1:20;
lw      = 3;
fs      = 12;
fn      = 'palatino';

%% Supply shock
hfig    = figure('color', 'w');
pos     = get(hfig,'position');
set(hfig,'position',pos.*[.5 1 2 2])

subplot(4, 4, 1), hold on
plot(time, IRF_u.u(time), 'linewidth', lw)
plot(time, IRF_u_f.u(time), '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('OPEC supply shock (u)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')

subplot(4, 4, 2), hold on
plot(time, -IRF_u.p(time), 'linewidth', lw)
plot(time, -IRF_u_f.p(time), '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('Oil price (P)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')

subplot(4, 4, 3), hold on
plot(time, -IRF_u.o(time), 'linewidth', lw)
plot(time, -IRF_u_f.o(time), '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('Oil production (O)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')

subplot(4, 4, 4), hold on
plot(time, -IRF_u.Y(time), 'linewidth', lw)
plot(time, -IRF_u_f.Y(time), '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('World GDP (Y)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
ax = gca;
ax.YAxis.Exponent = 0;

subplot(4, 4, 5), hold on
plot(time, -[0, IRF_u.theta_n(time(1:end-1))], 'linewidth', lw)
plot(time, -[0, IRF_u_f.theta_n(time(1:end-1))], '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('Non-OPEC extraction rate (\theta)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
ax = gca;
ax.YAxis.Exponent = 0;
ylim([-0.005 0.005])


subplot(4, 4, 6), hold on
plot(time, -[0, IRF_u.F_n(time(1:end-1))], 'linewidth', lw)
plot(time, -[0, IRF_u_f.F_n(time(1:end-1))], '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('Non-OPEC oil reserves (R)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
ax = gca;
ax.YAxis.Exponent = 0;
ylim([-0.005 0.005])

subplot(4, 4, 7), hold on
plot(time, -IRF_u.I_n(time), 'linewidth', lw)
plot(time, -IRF_u_f.I_n(time), '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('Non-OPEC investment (I)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
ax = gca;
ax.YAxis.Exponent = 0;
ylim([-0.005 0.005])

subplot(4, 4, 8), hold on
plot(time, -[0, IRF_u.X_n(time(1:end-1))], 'linewidth', lw)
plot(time, -[0, IRF_u_f.X_n(time(1:end-1))], '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('Non-OPEC exploration capital (X)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
ax = gca;
ax.YAxis.Exponent = 0;
ylim([-0.005 0.005])

subplot(4, 4, 9), hold on
plot(time, -[-IRF_u.u(1), IRF_u.theta_o(time(1:end-1))], 'linewidth', lw)
plot(time, -[-IRF_u.u(1), IRF_u_f.theta_o(time(1:end-1))], '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('OPEC extraction rate (e^{u}\theta )', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
ax = gca;
ax.YAxis.Exponent = 0;

subplot(4, 4, 10), hold on
plot(time, -[0, IRF_u.F_o(time(1:end-1))], 'linewidth', lw)
plot(time, -[0, IRF_u_f.F_o(time(1:end-1))], '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('OPEC oil reserves (R)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
ax = gca;
ax.YAxis.Exponent = 0;
ylim([-0.005 0.005])

subplot(4, 4, 11), hold on
plot(time, -IRF_u.I_o(time), 'linewidth', lw)
plot(time, -IRF_u_f.I_o(time), '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('OPEC investment (I)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
ax = gca;
ax.YAxis.Exponent = 0;
ylim([-0.005 0.005])

subplot(4, 4, 12), hold on
plot(time, -[0, IRF_u.X_o(time(1:end-1))], 'linewidth', lw)
plot(time, -[0, IRF_u_f.X_o(time(1:end-1))], '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('OPEC exploration capital (X)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
ax = gca;
ax.YAxis.Exponent = 0;
ylim([-0.005 0.005])

subplot(4, 4, 13), hold on
plot(time, -IRF_u_f.theta_f(time), '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('Fracking extraction rate (\theta)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
ax = gca;
ax.YAxis.Exponent = 0;
% ylim([-0.01 inf])

subplot(4, 4, 14), hold on
plot(time, -IRF_u_f.F_f(time), '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('Fracking oil reserves (R)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
ax = gca;
ax.YAxis.Exponent = 0;

subplot(4, 4, 15), hold on
plot(time, -IRF_u_f.I_f(time), '--r', 'linewidth', lw)
grid on
set(gca, 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
title('Fracking investment (I)', 'fontname', fn, 'fontsize', fs, 'fontweight', 'bold')
ax = gca;
ax.YAxis.Exponent = 0;

subplot(4, 4, 16), hold on
plot(time(1), time(1), 'linewidth', lw)
plot(time(2), time(2), '--r', 'linewidth', lw)
set(gca, 'visible', 'off')
legend('Model w/o fracking', 'Model with Fracking', 'fontname', fn, 'fontsize', fs+4, 'fontweight', 'bold', 'location', 'east')

print('../../Figures/Figure_5','-dpng')
